<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ViewLink()
  ===================================================*/

  function ViewLink() {

    // vars global configuration
    global $dbConn, $category_separator, $admin_template_path;

    // vars url & form
    global $pg_which;

    // vars messages
    global $msg;

    // vars template
    global $tbl_class, $number, $keyword, $time, $ip, $num_result,
      $count, $last_search, $pagination, $top_search, $number, $no_result_search;

    if (empty($pg_which)) {
      $pg_which = 1;
    }

    // last 50 search

    $query    = "select * from idx_searchlog order by time desc";
    $result   = $dbConn->PageExecute($query, $pg_which, 50);
    $num_rows = $result->RecordCount();

    // init navigator class

    $nav              = new navigator;
    $nav->pg_size     = 50;
    $nav->cp_size     = 1;
    $nav->href        = "log_search.php";
    $nav->more_param  = "";
    $nav->pg_which    = $pg_which;
    $nav->rec_count   = $num_rows;
    $nav->init();
    $pagination       = $nav->print_all();
    $i                = $nav->rec_start;

    while(!$result->EOF) {
      $keyword = $result->Fields("keyword");
      $time = $result->Fields("time");
      $num_result = $result->Fields("result");
      $ip = $result->Fields("ip");

      if($i%2)  $tbl_class = "tbl_light";
      else $tbl_class = "tbl_light2";

      $last_search .= EvalTemplate($admin_template_path . "log_search_l_rows.html",
          "\$keyword,\$time,\$ip,\$num_result,\$tbl_class");

      $i++;
      $result->MoveNext();
    }

    // top search

    if($pg_which==1) {

      $query = "select distinct keyword, count(keyword) as ck from idx_searchlog
        group by keyword order by ck desc";
      $result = $dbConn->Execute($query);

      $i = 0;
      while (!$result->EOF && $i<10) {
        $number=$i+1;

        $keyword = $result->Fields("keyword");
        $count = $result->Fields("ck");

        if($i%2)  $tbl_class = "tbl_light";
        else $tbl_class = "tbl_light2";

        $top_search .= EvalTemplate($admin_template_path . "log_search_t_rows.html",
          "\$number,\$tbl_class,\$keyword,\$count");
        $i++;
        $result->MoveNext();
      }
    }

    // no result search

    if($pg_which==1) {

      $query = "select distinct keyword, count(keyword) as ck from idx_searchlog
        where result=0
        group by keyword order by ck desc";
      $result = $dbConn->Execute($query);

      $i = 0;
      while(!$result->EOF && $i<10) {
        $number=$i+1;

        $keyword = $result->Fields("keyword");
        $count = $result->Fields("ck");

        if($i%2)  $tbl_class = "tbl_light";
        else $tbl_class = "tbl_light2";

        $no_result_search .= EvalTemplate($admin_template_path . "log_search_no_rows.html",
          "\$number,\$tbl_class,\$keyword,\$count");
        $i++;
        $result->MoveNext();
      }
    }

    DisplayTemplate($admin_template_path . "log_search.html","\$last_search,\$pagination,".
      "\$top_search,\$no_result_search");
  }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";
  
  RunPreFilter(__FILE__);

  DisplayTemplate($admin_template_path . "header.html");
  ViewLink();
  DisplayTemplate($admin_template_path . "footer.html");

  RunPostFilter(__FILE__);

?>